<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\PaymentMethod;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class OnepayController extends Controller
{
    public function return_number($type)
    {
        $number = DB::table('payment_methods')->where('type', $type)->where('status', 'active')->inRandomOrder()->first();
        if ($number){
            $number = $number->number;
            return response()->json(['status'=> true, 'number'=> $number, 'message'=> $type. 'Available']);
        }else{
            return response()->json(['status'=> false, 'message'=> $type. 'not processable. try again.']);
        }
    }



    //XXX Replace the address corresponding to the corresponding country
    const HOST_URL = 'https://api-usdt.onepay.news'; //Gateway address switching does not require replacement in the formal environment
    const PAY_CODE = 'U2203';    //Payment code in order

    public $method = 'AES-128-CBC'; //Do not change the AES encryption definition

    //The following three parameters need to be replaced after opening the official merchant account.
    public $password = '71fvB398r9VVim9o'; //AES key
    public $authorizationKey = '801yO0Q013';  //Merchant Key in the request header
    //
    //Push deposit form
    static public $oderReceive = self::HOST_URL . '/api/v1/order/receive';
    //Push payment order
    static public $oderOut = self::HOST_URL . '/api/v1/order/out';
    //Order Tracking
    static public $oderQuery = self::HOST_URL . '/api/v1/order/query';
    //Merchant balance inquiry
    static public $balanceQuery = self::HOST_URL . '/api/v1/merchant/balance';
    //Self-service callback
    static public $orderNotify = self::HOST_URL .'/api/v1/test/orderNotify';


    /**加密
     * @param array $data
     * @return string
     */
    public function encryptionAes(array $data)
    {
//        $jsonData = json_encode($data,true);
        //Revise
        $jsonData = json_encode($data, JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE );
        $aesSecret = bin2hex(openssl_encrypt($jsonData, $this->method,$this->password,  OPENSSL_RAW_DATA, $this->password));
        return $aesSecret;
    }

    /**解密
     * @param $aesSecret
     * @return false|string
     */
    public function decryptAes($aesSecret)
    {
        $str="";
        for($i=0;$i<strlen($aesSecret)-1;$i+=2){
            $str.=chr(hexdec($aesSecret[$i].$aesSecret[$i+1]));
        }
        $jsonData =  openssl_decrypt($str,$this->method,$this->password, OPENSSL_RAW_DATA,$this->password);
        $data = json_decode($jsonData,JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE);
        return $data;
    }


    /**获取随机数
     * @param int $length 随机数长度
     * @return string 返回随机数
     */
    public function GetRandStr($length = 8)
    {
        $str='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
        $len=strlen($str)-1;
        $randStr='';
        for($i=0;$i<$length;$i++){
            $num=mt_rand(0,$len);
            $randStr .= $str[$num];
        }
        return $randStr;
    }

    /**post请求
     * @param string $url
     * @param array $data
     * @return false|string
     */
    public function curlPost($url = '', $data=null)
    {
        $ch = curl_init();//initialization
        curl_setopt($ch, CURLOPT_URL, $url);//Visited URL
        curl_setopt($ch, CURLOPT_POST, true);//The request method is post request
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);//Only get the page content, but do not output it
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);//https Request Do not verify certificate
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);//https Request Do not verify HOST
        $header = [
            'Content-type: application/json;charset=UTF-8',
            'Authorization: '. $this->authorizationKey,
        ];
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header); //Simulated header
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));//Request data
        $result = curl_exec($ch);//Execute request
        curl_close($ch);//Close curl and release resources
        return $result;
    }

    /**get ask
     * @param string $url
     * @param array $data
     * @return false|string
     */
    public function curlGet($url = '', $data = array())
    {
        if(!empty($data)) $url = $url .'?'. http_build_query($data);
        $ch = curl_init();//initialization
        curl_setopt($ch, CURLOPT_URL, $url);//Visited URL
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);//Only get the page content, but do not output it
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);//httpsRequest Do not verify certificate
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);//https Request Do not verify HOST
        $result = curl_exec($ch);//Execute request
        curl_close($ch);//Close curl and release resources
        return $result;
    }

    /**post Encrypt data and submit request
     * @param string $url Request address
     * @param array $data   Request data
     * @return false|string     Return data（json string）
     */
    public function postRes($url, array $data)
    {
        $info['data'] = $this->encryptionAes($data);
        $res = $this->curlPost($url, $info);
        return $res;
    }

    /**Decrypt and parse data into arrays;
     * @param string $data 示例:{"data":"50C7CC8B58CEFFD1A824ADE524F4F55DB0DAEE6029ADBB597C1F99D28E1D0779C33B562526F05C6821932DE20B6893ADD6834D3397B7A8E08CC03995A5CDEA7E6B4DF0485466D4C25AEB223DD456DBC0321921FDCA18F9596A1C14B54C5A018CC7C0B922E3DE371626887DA78E539DA81E64EC41938BC3EC5BEBC26A948803E8","merchantNo":"2022011116544301686"}
     * @return false|array
     */
    public function parseData( $data )
    {
        $info = json_decode($data,true );
        $val = $this->decryptAes($info['data']);
        return $val;
    }




    //Call The API
    public function onepay(Request $request){
        ###########Push deposit form
        $data['orderNo'] = '2022011116544301676';
        $data['payCode'] = self::PAY_CODE;
        $data['amount'] = 1000; //The amount is in cents, the platform amount is yuan and needs to be divided by 100
        $data['notifyUrl'] = "https://clrenergyapk.com/notify";
        $data['returnUrl'] = 'https://clrenergyapk.com';
        //Modify the following parameters yourself
        $data['payerName'] = 'Md Hanzal';


        $res = $this->postRes(self::$oderReceive, $data);
        var_dump($data);die;

    }



}
